// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model;

import java.util.Collection;

/**
 * Interface for a type which type is not defined yet,
 * but which can already be registered with the TypeRegistry.
 * This is intended to be used in late-binding schema parsers.
 * 
 * @author Stefan Makswit
 */
public interface UnspecifiedType extends PropertyType
{
	/**
	 * @return Returns a list of the properties that reference this type. 
	 */
	Collection<PropertyDescription> getReferences();

	/**
	 * Adds adds a reference to a property.
	 * 
	 * @param property a property
	 */
	void addReference(PropertyDescription property);
}
