// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model.rules;

import com.adobe.xmp.schema.model.SchemaVisitor;
import com.adobe.xmp.schema.model.TypeRule;
import com.adobe.xmp.schema.model.XMPSchemaException;


/**
 * This rule applies for the type "Date".
 * 
 * @author Stefan Makswit
 */
public class DateRule implements TypeRule
{
	private static final long serialVersionUID = 1L;
	/** operator used to compare the operand with the actual XMP value */
	private ComparisonOperator operator;
	/** the operand is an ISO8601 date string */
	private String operand;

	
	/**
	 * Constructs a new DateRule.
	 * 
	 * @param operator the comparison operator
	 * @param operand the date to compare with
	 */
	public DateRule(ComparisonOperator operator, String operand)
	{
		this.operator = operator;
		this.operand = operand;
	}


	/**
	 * @return Returns the operator.
	 */
	public ComparisonOperator getOperator()
	{
		return this.operator;
	}


	/**
	 * @return the argument.
	 */
	public String getOperand()
	{
		return this.operand;
	}
	
	
	/**
	 * @see com.adobe.xmp.schema.model.TypeRule#accept(com.adobe.xmp.schema.model.SchemaVisitor)
	 */
	public void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException
	{
		schemaVisitor.visit(this);
	}
}
