/*
 * File: RNGParseException.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.xmp.schema.rng.parser.exceptions;

/**
 * Base class of exceptions encountered while parsing RelaxNG schema to constuct XMP schemas.
 * 
 * @author hraghav
 */
public class RNGParseException extends RuntimeException
{

	private static final long serialVersionUID = 3954153244247976307L;

	/**
	 * 
	 * Constructs a new RNGParseException.
	 * 
	 * @param message
	 *            the detail message
	 */
	public RNGParseException(String message)
	{
		super(message);
	}

	/**
	 * 
	 * Constructs a new RNGParseException.
	 * 
	 * @param message
	 *            the detail message
	 * @param t
	 *            the cause (which is saved for later retrieval
	 */
	public RNGParseException(String message, Throwable t)
	{
		super(message, t);
	}
}
