package com.adobe.xmp.schema.service;

import com.adobe.xmp.schema.model.SchemaDescription;


/**
 * Interface for a schema description cache.
 * 
 * @author Stefan Makswit
 */
public interface SchemaCache
{
	/**
	 * Retrieves an {@link com.adobe.xmp.schema.model.SchemaDescription} from the cache.
	 * @param namespaceURI the namespace to lookup
	 * @return Returns the schema description or <code>null</code>,
	 * 		   if it has not been cached.
	 */
	SchemaDescription get(String namespaceURI);
	
	
	/**
	 * Adds a schema description to the cache.
	 * 
	 * @param schema an {@link com.adobe.xmp.schema.model.SchemaDescription}
	 */
	void put(String namespaceURI, SchemaDescription schema);
}
