/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ConsumerType;
import org.osgi.framework.Constants;

/**
 * Interface to be implemented by clients who want to provide their own logic
 * for generating {@code s.pageName} for Analytics or retrieving {@link Resource}s from
 * custom pageName's.
 * 
 * Registered {@link AnalyticsPageNameProvider} will be called based on their
 * {@link Constants#SERVICE_RANKING}. If one implementation can provide a value, then this
 * value will be taken and remaining providers are not called anymore.
 */
@ConsumerType
public interface AnalyticsPageNameProvider {
    /**
     * Called when pageName for a resource is requested.
     *
     * @param context
     *            the resolution {@link AnalyticsPageNameContext}
     * @return {@code null} or the generated pageName
     */
    public String getPageName(AnalyticsPageNameContext context);
    
    /**
     * Called when the {@link Resource} for a given pageName is requested.
     * 
     * @param context the resolution {@link AnalyticsPageNameContext}
     * @return {@code null} or the resource that matches the pageName provided via context
     */
    public Resource getResource(AnalyticsPageNameContext context);
}
