/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.sitecatalyst.datainsertion;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The <code>DataInsertionResponse</code> holds the response information.
 */
@ProviderType
public interface DataInsertionResponse {

    /**
     * Returns the request success status.
     * 
     * @return <code>true</code> if request succeeded, <code>false</code>
     *         otherwise
     */
    boolean isSuccess();

    /**
     * Returns a string representation of the reason if the request was not
     * successful.
     * 
     * @return Reason for failure or <code>null</code> if not available
     */
    String getReason();

    /**
     * Returns a String representation of the response body.
     * 
     * @return Response body
     */
    String getResponseBody();

}