/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget;

import org.apache.commons.lang.StringUtils;

/**
 * A data-object that holds data related to list filtering
 */
public class ListFilter {

    private String property;
    private String value;

    /**
     * Sets the property used for list filtering
     * @param p a {@link String} representing the name of the property
     * @return an instance of this object
     */
    public ListFilter property(String p) {
        if (StringUtils.isNotEmpty(p)) {
            this.property = p;
        } else {
            this.property = null;
        }
        return this;
    }

    /**
     * Sets the value of the property used for filtering
     * @param v a {@link String} representation of the value of the property
     * @return an instance of this object
     */
    public ListFilter value(String v) {
        if (StringUtils.isNotEmpty(v)) {
            this.value = v;
        } else {
            this.value = null;
        }

        return this;
    }

    /**
     * Returns the name of the property used for filtering
     * @return a {@link String} representing the name of the property
     */
    public String getProperty() {
        return this.property;
    }

    /**
     * Returns the value of the property used for filtering
     * @return a {@link String} representing the value of the property
     */
    public String getValue() {
        return this.value;
    }

}
