/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget;

import org.apache.commons.lang.StringUtils;

/**
 * A data-object that holds data related to list sorting - property and direction
 *
 */
public class ListSorter {

    private String property;
    private boolean ascending;

    /**
     * Sets the property for this sorter
     * @param p a {@link String} object representing the name of the property
     * @return an instance of this object
     */
    public ListSorter property(String p) {
        if (StringUtils.isNotEmpty(p)) {
            this.property = p;
        } else {
            this.property = null;
        }
        return this;
    }

    /**
     * Signals that the sorting should be done in acending mode
     * @return an instance of this object
     */
    public ListSorter ascending() {
        this.ascending = true;
        return this;
    }

    /**
     * Signals that sorting should be done in descending mode
     * @return an instance of this object
     */
    public ListSorter descending() {
        this.ascending = false;
        return this;
    }

    /**
     * Returns the type of sorting that is used
     * @return <code>true</code> if this sorter uses ascending sorting, <code>false</code> otherwise
     */
    public boolean isAscending() {
        return this.ascending;
    }

    /**
     * Returns the name of the property used for sorting
     * @return a {@link String} representing the name of the property used for sorting.
     */
    public String getProperty() {
        return this.property;
    }

}
