/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Contains data for a single report interval
 * 
 * @see <a href="https://developer.omniture.com/en_US/documentation/test-target/r-performance-report"> Adobe Target
 *      performance report API</a>
 */
public class Sample {

    private final Date start;
    private final Resolution duration;

    private final List<Recipe> recipes = new ArrayList<Recipe>();

    public Sample(Date start, Resolution duration) {
        this.start = start;
        this.duration = duration;
    }

    public void addRecipe(Recipe recipe) {
        recipes.add(recipe);
    }


    public Date getStart() {
        return start;
    }

    public Resolution getDuration() {
        return duration;
    }

    public List<Recipe> getRecipes() {
        return recipes;
    }
}