/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.math.BigDecimal;

/**
 * Contains the data from a single success metric
 * 
 * @see <a href="https://developer.omniture.com/en_US/documentation/test-target/r-performance-report"> Adobe Target
 *      performance report API</a>
 */
public class Step {

    public static final String NAME_DISPLAY_MBOXES = "Display mboxes";

    private final String name;
    private final BigDecimal count;

    public Step(String name, BigDecimal count) {
        this.name = name;
        this.count = count;
    }

    public String getName() {
        return name;
    }

    public BigDecimal getCount() {
        return count;
    }

    @Override
    public String toString() {

        return getClass().getSimpleName() + "[ name : " + name + ", count: " + count + "]";
    }
}