/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.util.Date;

/**
 * The representation of a Testandtarget Audience
 */
public class TestandtargetAudience {
    private Date createdAt;
    private String createdBy;
    private String description;
    private long id;
    private Date modifiedAt;
    private String modifiedBy;
    private String name;

    /**
     * Get the date when this audience was created
     * @return the {@link Date} of the audience's creation
     */
    public Date getCreatedAt() {
        return createdAt;
    }

    /**
     * Returns the name of the user that created this audience, as stored in Adobe Target
     * @return the {@link String} containing this audience's creator
     */
    public String getCreatedBy() {
        return createdBy;
    }

    /**
     * Get the description of this audience
     * @return a {@link String} containing the audience's description
     */
    public String getDescription() {
        return description;
    }

    /**
     * Returns the audience's id, as retrieved from Adobe Target
     * @return the id of the audience.
     */
    public long getId() {
        return id;
    }

    /**
     * Get the date when this audience was last modified
     * @return the {@link Date} of the audience's last modification
     */
    public Date getModifiedAt() {
        return modifiedAt;
    }

    /**
     * Returns the name of the user that last modified this audience, as stored in Adobe Target
     * @return the {@link String} containing the user name that last modified this audience
     */
    public String getModifiedBy() {
        return modifiedBy;
    }

    /**
     * Returns the name of the audience
     * @return a {@link String} object containing the audience name
     */
    public String getName() {
        return name;
    }
}
