/*************************************************************************
  *
  * ADOBE CONFIDENTIAL
  * __________________
  *
  *  Copyright 2012 Adobe Systems Incorporated
  *  All Rights Reserved.
  *
  * NOTICE:  All information contained herein is, and remains
  * the property of Adobe Systems Incorporated and its suppliers,
  * if any.  The intellectual and technical concepts contained
  * herein are proprietary to Adobe Systems Incorporated and its
  * suppliers and may be covered by U.S. and Foreign Patents,
  * patents in process, and are protected by trade secret or copyright law.
  * Dissemination of this information or reproduction of this material
  * is strictly forbidden unless prior written permission is obtained
  * from Adobe Systems Incorporated.
  **************************************************************************/
package com.day.cq.analytics.testandtarget;

import java.io.IOException;

import javax.servlet.ServletException;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.HtmlResponse;
import org.osgi.annotation.versioning.ProviderType;


/**
 * The interface for commands executed by {@link com.day.cq.analytics.testandtarget.impl.servlets.CommandServlet}.
 */
@ProviderType
public interface TestandtargetCommand {

    /**
     * The command's action name.
     * @return Name of action
     */
    String getName();
    
    /**
     * Executes the actual command.
     * @param request The request object
     * @param response The response object
     * @return The HTML response of the command
     * @throws ServletException {@link ServletException}
     * @throws IOException {@link IOException}
     */
    HtmlResponse performCommand(SlingHttpServletRequest request, 
                                SlingHttpServletResponse response) throws ServletException, IOException;
    
}
