/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 * Copyright 2015 Adobe Systems Incorporated
 * All Rights Reserved.
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget.util;

/**
 * Holds the campaign types supported by this integration.
 */
public enum CampaignType {

    AB("abn","A/B Test"),                               //i18n.get("A/B Test")
    LANDING_PAGE("landingPage","Experience Targeting"); //i18n.get("Experience Targeting")

    private String type;
    private String typeLabel;

    CampaignType(String type, String label) {
        this.type = type;
        this.typeLabel = label;
    }

    /**
     * Retrieve a string representation of this campaign type
     * @return the campaign type as a {@link String}
     */
    public String getType() {
        return type;
    }

    /**
     * @return a {@link String} representing the label of the campaign type
     */
    public String getTypeLabel() {
        return typeLabel;
    }

    /**
     * Creates an object of this type based on the string representation of a campaign's type
     * @param type the type of the campaign, in {@link String} format - "ab" or "landingPage"
     * @return a {@link CampaignType} object or <code>null</code> if the campaign type is not defined
     */
    public static CampaignType fromString(String type) {
        if ("abn".equals(type)) {
            return CampaignType.AB;
        } else if ("landingPage".equals(type)) {
            return CampaignType.LANDING_PAGE;
        }

        return null;
    }
}
