/*******************************************************************************
 * ADOBE CONFIDENTIAL
 * __________________
 *
 * Copyright 2019 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 ******************************************************************************/

package com.day.cq.analytics.testandtarget.workspaces;

import com.adobe.cq.adobeims.imsprofile.ImsProfileProdCtx;

import javax.annotation.Nonnull;
import java.util.Objects;

/**
 * Represents an Adobe Target workspace
 */
public class Workspace {

    public Workspace(@Nonnull ImsProfileProdCtx imsProfile) {
        this.id = imsProfile.getGroupId();
        this.name = imsProfile.getUserVisibleName();
    }

    public Workspace(String id, String name) {
        this.id = id;
        this.name = name;
    }

    private final String id;
    
    private final String name;

    /**
     * @return the technical id of the workspace
     */
    public String getId() {
        return id;
    }

    /**
     * @return the user visible name of the workspace
     */
    public String getName() {
        return name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Workspace workspace = (Workspace) o;
        return id.equals(workspace.id) &&
                name.equals(workspace.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name);
    }

    @Override
    public String toString() {
        return "Workspace{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
