/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.audit;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;


/**
 * The <code>AuditEvent</code> class represents the class for an audit event.
 */
public class AuditLogEntry implements Serializable {

    private static final long serialVersionUID = 9115969134511819580L;

    /** time of event
     */
    protected final Date time;

    /** userid
     */
    protected final String userid;

    /** path
     */
    protected final String path;

    /** the event type
     */
    protected final String type;

    /** category
     */
    protected final String category;

    /** properties (optional)
     */
    protected final Map<String, Object> properties;

    /**
     * Create a new AuditLogEntry.
     * @param category The category of the entry  (required)
     * @param time The date of the action (required)
     * @param userid The userid (required)
     * @param path The path of the action (required)
     * @param type The action type (required)
     * @param properties A map of key value pairs (optional). All objects in the map must be serializable.
     */
    public AuditLogEntry(String category,
                         Date time,
                         String userid,
                         String path,
                         String type,
		                 Map<String, Object>    properties) {
        if ( category == null ) {
            throw new IllegalArgumentException("Category must not be null.");
        }
        if ( time == null ) {
            throw new IllegalArgumentException("Time must not be null.");
        }
        if ( userid == null ) {
            throw new IllegalArgumentException("Userid must not be null.");
        }
        if ( path == null ) {
            throw new IllegalArgumentException("Path must not be null.");
        }
        if ( type == null ) {
            throw new IllegalArgumentException("Type must not be null.");
        }
    	this.time = time;
    	this.userid = userid;
    	this.path = path;
    	this.type = type;
    	this.category = category;
    	this.properties = properties;
    }

    /**
     * Return the date of the audit log entry.
     */
    public Date getTime() {
        return time;
    }

    /**
     * Returns the user id.
     */
    public String getUserId() {
        return userid;
    }

    /**
     * The path.
     * @return The path.
     */
    public String getPath() {
        return path;
    }

    /**
     * Returns the type of this audit log entry (this depends on the category)
     */
    public String getType() {
        return type;
    }

    /**
     * Return the category for this log entry.
     */
    public String getCategory() {
        return category;
    }

    /**
     * This is an application specific property map.
     * @return The map or null if not specified.
     */
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}
