/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.audit;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

/**
 * The <code>AuditLogEvent</code> class represents the class for an audit event.
 */
public class AuditLogEvent implements Serializable {

    private static final long serialVersionUID = 8029847202889440626L;

    /** The job topic for adding an entry to the audit log. */
    public static final String JOB_TOPIC = "com/day/cq/audit/job";

    /** The event property holding the {@link AuditLogEntry}. */
    public static final String AUDIT_EVENT_PROPERTY = "com.day.cq.audit.event";

    /** The list of entries */
    private final List<AuditLogEntry> entries;

    /**
     * Create a new audit log event.
     * @param entries The list of audit log entries.
     */
    public AuditLogEvent(final List<AuditLogEntry> entries) {
        this.entries = entries;
    }

    /**
     * Get the list of entries.
     * @return An iterator for the entries.
     */
    public Iterator<AuditLogEntry> getEntries() {
        return this.entries.iterator();
    }

}
