/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons;

/**
 * Describes a resource that provides some information about its labels. 
 */
public interface LabeledResource {

    /**
     * Returns the path of this resource
     * @return the path of this resource
     */
    String getPath();

    /**
     * Returns the name of this resource. this is usually the last segment of
     * it's path.
     * @return the name of the resource
     */
    String getName();

    /**
     * Returns the tile of this resource.
     * @return the tile of this resource or <code>null</code> if not defined.
     */
    String getTitle();

    /**
     * Returns the description of this resource.
     * @return the description of this resource or <code>null</code> if not defined.
     */
    String getDescription();
}