/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.feed;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;

import javax.jcr.RepositoryException;
import java.io.*;
import com.day.cq.commons.SimpleXml;

/**
 * The <code>AtomFeed</code> class prints a resource as an Atom feed.
 * @deprecated Use the Apache Sling Atom Tag Library instead.
 */
public class AtomFeed extends AbstractFeed {

    /**
     * Creates a new <code>AtomFeed</code> instance using the specified
     * servlet request and response. The resource to render will be taken
     * from the request.
     * @param req The servlet request
     * @param resp The servlet response
     * @throws RepositoryException if no node can be found
     */
    public AtomFeed(SlingHttpServletRequest req, SlingHttpServletResponse resp)
            throws RepositoryException {
        super(null, req, resp);
    }

    /**
     * Creates a new <code>AtomFeed</code> instance using the specified
     * resource, servlet request and response.
     * @param res The resource
     * @param req The servlet request
     * @param resp The servlet response
     * @throws RepositoryException if no node can be found
     */
    public AtomFeed(Resource res, SlingHttpServletRequest req, SlingHttpServletResponse resp)
            throws RepositoryException {
        super(res, req, resp);
    }

    /**
     * {@inheritDoc}
     */
    public void printHeader() throws IOException {
        initXml();
        xml.openDocument();
        SimpleXml.Element feed = xml.open("feed");
        feed.attr("xmlns", "http://www.w3.org/2005/Atom");
        if (!"".equals(getLanguage())) {
            feed.attr("xml:lang", getLanguage());
        }
//        feed.attr("xml:base", getBaseUrl());

        xml.open("title", getTitle(), false)
        .attr("type", "html")
        .close();

        xml.open("author");
        xml.open("name", getAuthorName(), true).close();
        if (!"".equals(getAuthorEmail())) {
            xml.open("email", getAuthorEmail(), false).close();
        }
        xml.close();

        xml.open("id", getFeedLink(), false).close();

        xml.open("link")
        .attr("rel", "alternate")
        .attr("type", "text/html")
        .attr("href", getHtmlLink())
        .close();

        xml.open("link")
        .attr("rel", "self")
        .attr("type", getContentType())
        .attr("href", getFeedLink())
        .close();

        xml.open("updated", getPublishedDate(), false).close();
    }

    /**
     * {@inheritDoc}
     */
    public void printEntry() throws IOException {
        initXml();
        xml.omitXmlDeclaration(true);
        xml.open("entry");

        xml.open("title", getTitle(), false)
        .attr("type", "html")
        .close();

        xml.open("summary", getSummary(), false)
        .attr("type", "html")
        .close();

        xml.open("author");
        xml.open("name", getAuthorName(), true).close();
        if (!"".equals(getAuthorName())) {
            xml.open("email", getAuthorEmail(), false).close();
        }
        xml.close();

        xml.open("id", getFeedLink(), false).close();

        xml.open("updated", getPublishedDate(), false).close();
        xml.open("published", getPublishedDate(), false).close();

        xml.open("category")
        .attr("term", getTags())
        .close();

        if (isFile()) {

            xml.open("link")
            .attr("rel", "alternate")
            .attr("type", getMimeType())
            .attr("href", getFileLink())
            .close();

            xml.open("link")
            .attr("rel", "enclosure")
            .attr("type", getMimeType())
            .attr("length", getFileSize())
            .attr("href", getFileLink())
            .close();

        } else {

            xml.open("link")
            .attr("rel", "alternate")
            .attr("type", getMimeType())
            .attr("href", getHtmlLink())
            .close();

            xml.open("link")
            .attr("rel", "replies")
            .attr("type", getMimeType())
            .attr("href", getCommentsLink())
            .close();

            xml.open("content")
            .attr("xml:base", getBaseUrl())
            .attr("type", "html")
            .text(getDescription(), false)
            .close();

        }

        xml.tidyUp();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getContentType() {
        return "application/atom+xml";
    }


}
