package com.day.cq.commons.predicate;

import com.day.cq.commons.jcr.JcrConstants;
import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

/**
 * Predicate used to filter nodes of type nt:unstructured.
 * @deprecated use  {@link com.day.cq.commons.predicates.IsUnstructuredPredicate} instead
 */
@Component(metatype = false)
@Service(Predicate.class)
@Properties({
        @Property(name = "predicate.name", value = "unstructured")
})
@Deprecated
public class IsUnstructuredPredicate extends AbstractNodePredicate implements Predicate {
    private final Logger log = LoggerFactory.getLogger(IsUnstructuredPredicate.class);

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if node is or extends nt:unstructured
     * @deprecated use  {@link com.day.cq.commons.predicates.IsUnstructuredPredicate#test(Node)} instead
     */
    @Deprecated
    public boolean evaluate(Node node) throws RepositoryException {
        log.warn("IsUnstructuredPredicate has been deprecated. Please use com.day.cq.commons.predicates.IsUnstructuredPredicate instead.");
        return node.isNodeType(JcrConstants.NT_UNSTRUCTURED);
    }

}