/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 * 
 * Copyright 2024 Adobe
 * All Rights Reserved.
 * 
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.commons.predicates;

import org.osgi.annotation.versioning.ProviderType;

import java.util.function.Predicate;

/**
 * Provider that returns registered predicates.
 */
@ProviderType
public interface PredicateProvider {

    /**
     * Returns the registered predicate.
     *
     * @param name name of the predicate to retrieve
     * @return predicate or <code>null</code>
     *
     */
    Predicate getPredicate(String name);

}
