/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 * 
 * Copyright 2024 Adobe
 * All Rights Reserved.
 * 
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.commons.predicates;

import java.util.function.Predicate;
import org.apache.sling.api.adapter.Adaptable;

/**
 * Predicate used to filter resources based on their adaptability.
 */
public class ResourceFilter implements Predicate<Adaptable> {

    /**
     * class to filter on
     */
    private final Class filterClass;

    /**
     * Creates a new resource filter for the given class
     * @param filterClass the class to filter on
     */
    public ResourceFilter(Class filterClass) {
        this.filterClass = filterClass;
    }

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if o is a Resource and adapts to the respective
     * filter class.
     */
    @SuppressWarnings("unchecked")
    public boolean test(Adaptable o) {
        return o != null
                && o.adaptTo(filterClass) != null;
    }

}
