/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.servlets;

import org.apache.sling.api.servlets.HtmlResponse;

/**
 * Helper class for creating status responses for html requests.
 * @deprecated use {@link HtmlStatusResponseFactory} instead
 */
@Deprecated
public class HtmlStatusResponseHelper {

    /**
     * Create a html status response
     *
     * @param success <code>true</code> if action succeeded
     * @param message Action/error message
     * @param path    path of the "modified" page
     *
     * @return the html response
     */
    public static HtmlResponse createStatusResponse(boolean success,
                                                    String message, String path) {
        return createStatusResponse(success ? 200 : 500, message, path);
    }

    /**
     * Create a html status response
     *
     * @param status status code
     * @param message Action/error message
     * @param path    path of the "modified" page
     *
     * @return the html response
     */
    public static HtmlResponse createStatusResponse(int status, String message,
                                                    String path) {
        final HtmlResponse response = new HtmlResponse();
        if (path != null) {
            response.setPath(path);
            response.setLocation(path);
            final int pos = path.lastIndexOf('/');
            response.setParentLocation(path.substring(0, pos));
        }
        response.setStatus(status, message);
        if (status < 400) {
            response.setTitle("OK");
        } else {
            response.setTitle(" Error");
        }
        return response;
    }

    /**
     * Create a html status response
     *
     * @param success <code>true</code> if action succeeded
     * @param message Action/error message
     *
     * @return the html response
     */
    public static HtmlResponse createStatusResponse(boolean success, String message) {
        return createStatusResponse(success, message, null);
    }

    /**
     * Create a html status response
     *
     * @param status http status code
     * @param message Action/error message
     *
     * @return the html response
     */
    public static HtmlResponse createStatusResponse(int status, String message) {
        return createStatusResponse(status, message, null);
    }

    /**
     * Create a html status response
     *
     * @param success <code>true</code> if action succeeded
     * @param messages Action/error messages
     * @param paths    paths of the "modified" page
     *
     * @return the html response
     */
    public static HtmlResponse createStatusResponse(boolean success,
                                                    String[] messages,
                                                    String paths[]) {
        final StringBuffer buffer = new StringBuffer();
        for (final String msg : messages) {
            buffer.append(msg).append('\n');
        }
        return createStatusResponse(success, buffer.toString(), (paths != null && paths.length > 0 ? paths[0]: null));
    }
}