/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.contentsync.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.contentsync.config.ConfigEntry;

public abstract class AbstractDefaultContentUpdateHandler extends HashableContentUpdateHandler {

    /**
     * The name of the property that defines the target path.
     */
    public static final String CONFIG_TARGET_PATH_PREFIX = "targetRootDirectory";

    private static final Logger log = LoggerFactory.getLogger(AbstractDefaultContentUpdateHandler.class);

    /**
     * Returns the cache root path for the given entry.
     *
     * @param configEntry     The config entry
     * @param configCacheRoot The cache root prefix.
     * @return the cache root path
     */
    protected String getConfigCacheRoot(ConfigEntry configEntry, String configCacheRoot) {
        String prefixPath = configEntry.getValue(CONFIG_TARGET_PATH_PREFIX);
        if (prefixPath != null) {
            return configCacheRoot + "/" + prefixPath;
        }
        return configCacheRoot;
    }

    /**
     * Get content path and resolve path if relative.
     *
     * @param configEntry The config entry
     * @return resolved path for ConfigEntry's contentPath
     */
    protected String getResolvedContentPath(ConfigEntry configEntry) {
        String configuredContentPath = configEntry.getContentPath();
        String contentPath = configuredContentPath;
        if (configuredContentPath.startsWith("..") || configuredContentPath.startsWith(".")) {
            contentPath = configEntry.getPath() + "/" + configuredContentPath;
            log.debug("Configured path '" + configuredContentPath + "' resolved to '" + contentPath + "'");
        }
        return contentPath;
    }
}
