package com.day.cq.dam.api;

import org.apache.sling.api.resource.ResourceResolver;

import java.util.List;

/**
 * The <code>AssetReferenceHandler</code> provides api to look up and manage the references of a given asset.
 * Implementation of this interface should be exposed as a component.
 * The implementations will be module specific. Each module (commerce, forms, dam, wcm, etc) will implement
 * their own handlers to optimize the search within their own content spaces.
 */
public interface AssetReferenceHandler {

    /**
     * This method looks up references of a given asset in the content space which the implementation class
     * decides.
     *
     * @param assetPath The asset path to look for
     * @param resolver ResourceResolver instance
     * @return the list of references of the given asset
     */
    List<String> lookupReferences(String assetPath, ResourceResolver resolver);

    /**
     * This method removes the references of a given asset in the content space which the implementation class
     * decides. Since different modules store the reference as their own property/node terminology,
     * @param assetPath The path of the asset
     * @param resolver ResourceResolver instance
     */
    void removeReferences(String assetPath, ResourceResolver resolver);
}
