/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api;

import java.io.IOException;


/**
 * Process bytes, extract thumbnail and/or metadata found and add them to a {@link Context}.
 */
public interface Processor {

    /**
     * Process a couple of bytes.
     *
     * @param buf buffer
     * @param off offset inside buffer
     * @param len number of bytes
     *
     * @throws IOException thrown in event of failure to process the bytes
     */
    public void process(byte[] buf, int off, int len) throws IOException;
}
