/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api;

/**
 * Exception used to indicate that a {@link Processor} encountered an error.
 */
public class ProcessorException extends Exception {

    /**
     * Processor that encountered error.
     */
    private final Processor processor;

    /**
     * Create a new instance of this class.
     *
     * @param msg message
     * @param t exception source
     * @param processor processor that encountered error
     */
    public ProcessorException(String msg, Throwable t, Processor processor) {
        super(msg, t);

        this.processor = processor;
    }

    /**
     * Return the processor that encountered error.
     *
     * @return processor
     */
    public Processor getProcessor() {
        return processor;
    }
}
