/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api.handler.store;

import java.util.Map;

import com.day.cq.dam.api.handler.AssetHandler;

/**
 * The <code>AssetStore</code> class ...
 */
public interface AssetStore {

    /** Icon size: small. */
    int SIZE_SMALL = 0;
    /** Icon size: medium. */
    int SIZE_MEDIUM = 1;
    /** Icon size: large. */
    int SIZE_LARGE = 2;

    /**
     * Get the media handler for the mime type.
     * @param mimeType The mime type.
     * @return Returns the special media handler for the mime type or if
     *         no special media handler is available, the default handler
     *         is returned.
     */
    AssetHandler getAssetHandler(String mimeType);

    /**
     * Return an array of all available media handlers.
     * @return An array of media handlers or an empty array if no handlers are
     *         registered.
     */
    AssetHandler[] getAllAssetHandler();

    /**
     * Return a map of {@link AssetHandlerInfo}s hashed by their service id.
     * @return a map of {@link AssetHandlerInfo}s hashed by their service id.
     */
    public Map<String, AssetHandlerInfo> getAssetHandlerInfos();

    /**
     * Returns the proper mime type for the given filename
     * @param filename filename
     * @return mime type as string
     *
     * @deprecated use {@link org.apache.sling.commons.mime.MimeTypeService#getMimeType(String)} instead
     */
    @Deprecated
    String getMimeType(String filename);

    /**
     * Return a file ending for a mime type.
     * @param mimeType - The mime type for which the file ending is to be found
     * @return the file ending for a mime type.
     * @deprecated use {@link org.apache.sling.commons.mime.MimeTypeService#getExtension(String)} instead
     */
    @Deprecated
    String getFileNameSuffix(String mimeType);

    /**
     * Return the full path to the icon.
     * @param mimeType - The mime type for which the icon is to be found
     * @param size - The size of the icon
     * @return the full path to the icon.
     * @deprecated no replacement
     */
    @Deprecated
    String getIconPath(String mimeType, int size);
}
