/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.api.renditions;

import aQute.bnd.annotation.ProviderType;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;

import java.util.List;
import java.util.Map;

/**
 * Service interface for creating dynamicMedia locally hosted or remotely hosted renditions for video or image
 * for DAM assets.
 *
 * @since 6.3 (S7) -- temp and needs to have accurate info
 */
@ProviderType
public interface DynamicMediaRenditionProvider {

    /**
     * Get the rendition for the given asset based on the given rules. (e.g. dynamic image with preset)
     *
     * @param asset asset for which to the rendition needs to be provided
     * @param rules a map of rendition rules
     * @return a dynamicMediaRendition that matches the required rules
     */
    Rendition getRendition(Asset asset, Map<String, Object> rules);

    /**
     * Get the renditions for the given asset based on the given rules. (e.g. dynamicMedia video renditions)
     *
     * @param asset asset for which to the rendition needs to be provided
     * @param rules a map of rendition rules
     * @return a list of all dynamicMediaRenditions of this asset that matches the required rules.
     */
    List<Rendition> getRenditions(Asset asset, Map<String, Object> rules);
}
