/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.api.s7dam.constants;

/**
 * defines constants, such as node types and property names for all things s7dam.
 */
public interface S7damConstants {

    /**
     * S7 property - asset type.
     */
    public static final String PN_S7_TYPE = "dam:s7damType";
    
    /**
     * S7 property - scene7 file.
     */
    public static final String PN_SCENE7_FILE = "dam:scene7File";

    /**
     * S7 property - S7 Asset handle.
     */
    public static final String PN_S7_ASSET_ID = "dam:s7damID";

    /**
     * S7 property - S7 Asset specifier for Viewer components.
     */
    public static final String PN_S7_FILE = "dam:s7damFile";

    /**
     * S7 property - S7 Server.
     */
    public static final String PN_S7_DOMAIN = "dam:s7damDomain";

    /**
     * S7 property - S7 on  Premise ptiff path
     */
    public static final String PN_S7_PTIFF_PATH = "dam:s7damOnPremisePTiffPath";

    /**
     * S7 property - image map for eCatalog
     */
    public static final String PN_S7_ECAT_IMAGEMAP = "dam:s7damImageMap";

    /**
     * S7 property - S7 on  Premise obtimized path for all non image assets that are written to s7dam nfs mount
     */
    public static final String PN_S7_OPTIMIZED_PATH = "dam:s7damOnPremiseOptimizedPath";


    /**
     * JCR Location for storage of s7 asset metadata.
     */
    public static final String S7_ASSET_METADATA_NODE = "jcr:content";

    /**
     * Defines pyramided image
     */
    public static final String S7_IMAGE = "Image";
    /**
     * Type that defines a S7 Image Set
     */
    public static final String S7_IMAGE_SET = "ImageSet";

    /**
     * Type that defines a Carousel Set
     */
    public static final String S7_CAROUSEL_SET = "CarouselSet";

    
    /**
     * Type that defines a S7 Swatch Set
     */
    public static final String S7_SWATCH_SET = "SwatchSet";
    
    /**
     * Type that defines a S7 Video Set
     */
    public static final String S7_VIDEO_SET = "VideoSet";
    
    /**
     * Type that defines a S7 Mixed Media Set.
     */
    public static final String S7_MIXED_MEDIA_SET = "MixedMediaSet";

    /**
     * Type that defines a S7 Media Set.
     */
    public static final String S7_MEDIA_SET = "MediaSet";

    /**
     * Type that defines a 2D Spin Set.
     */
    public static final String S7_SPIN_SET = "SpinSet";

    /**
     * Type that defines Video Set.
     */
    public static final String S7_VIDEO = "Video";

    /**
     * Type that defines Video with AVS renditions.
     */
    public static final String S7_VIDEO_AVS = "VideoAVS";

    /**
     * Type that defines a viewer preset.
     */
    public static final String S7_VIEWER_PRESET = "ViewerPreset";

    /**
     * S7 Dyanmic media rendition name
     *
     */
    public static final String PN_S7_PTIFF_RENDITION_NAME = "cqdam.pyramid.tiff";
    
    /**
     * Type that defines modifier node for is commnads
     */
    public static final String S7_IS_MODIFIER = "modifier";

    /**
     * ROOT Path of Image Serving configuration and settings etc.
     */
    public static final String IMAGESERVER_ROOT = "/etc/dam/imageserver";
    public static final String IMAGESERVER_CONFIGURATION = IMAGESERVER_ROOT + "/configuration";
    public static final String IMAGESERVER_SETTINGS = IMAGESERVER_CONFIGURATION + "/jcr:content/settings";
    public static final String DYNAMIC_MEDIA_CONFIGURATION = "/etc/dam/dynamicmediaconfig";

    /**
     * S7 presets path.
     */
    public static final String PRESETS_ROOT = "/libs/settings/dam/dm/presets";

    /**
     * viewer presets root
     */
    public static final String VIEWER_PRESETS= PRESETS_ROOT+"/viewer";

    /**
     * image presets root
     */
    public static final String IMAGE_PRESETS= "/conf/global/settings/dam/dm/presets/macros";

    /**
     * batch presets root
     */
    public static final String BATCHSET_PRESETS= "/conf/global/settings/dam/dm/presets/batchset";

    /**
     * Preview root
     */
    public static final String PREVIEW_ROOT = "libs/dam/preview";
    
    /**
     * Userdata
     */
    public static final String USERDATA = "userdata";
    
    /**
     * company settings
     */
    public static final String EXPIRATION = "settings/expiration";
    public static final String MAX_PIXELS = "settings/maxpix";
    public static final String BKG_COLOR = "settings/bkgcolor";
    public static final String DEFAULT_PIXELS = "settings/defaultpix";
    public static final String DEFAULT_THUMB_PIXELS = "settings/defaultthumbpix";
    public static final String JPEG_QUALITY = "settings/jpegquality";
    public static final String RES_MODE = "settings/resmode";
    public static final String DOWNLOAD_SAMPLE_CHROMA = "settings/downsamplechroma";
    public static final String ALLOW_DIRECT_ACCESS = "settings/allowdirectaccess";
    public static final String RESOLUTION           = "settings/resolution";

    /**
     * S7 video report path.
     */
    public static final String VIDEO_REPORTS_ROOT = "/var/dam/dm/analyticsreport";
    public static final String VIDEO_REPORT_SUITE_ID_PATH = "/conf/global/settings/dam/dm/presets/analytics/"
            + "jcr:content/" + USERDATA;
    public static final String VIDEO_REPORT_SUITE = "reportSuite";

	public static final String VIDEO_DURATION = "videoDuration";

    /**
     * can be used for s7 dynamicMedia rendition name
     */
    public static final String NAME = "name";

    /**
     * can be used for s7 dynamicMedia rendition settings
     */
    public static final String SETTINGS = "settings";

    /**
     * can be used for s7 dynamicMedia rendition that is managed remotely
     */
    public static final String REMOTE = "remote";

    /**
     * can be used for s7 dynamicMedia rendition that is managed lcoally
     */
    public static final String LOCAL = "local";

    /**
     * s7 dynamicMedia asset type: image
     */
    public static final String IMAGE = "image";

    /**
     * s7 dynamicMedia asset type: video
     */
    public static final String VIDEO = "video";
    
    /**
     * smart crop specific
     * */
    public static final String SMART_CROP  = "smartcrop";

    /**
     * Type that defines ThreeD asset (Dimensional).
     */
    public static final String THREE_D = "ThreeD";

    /**
     * The name of the Feature Toggle for 3D delivery feature.
     */
    static final String FT_CQ_4283511 = "FT_CQ-4283511";

}
