/*
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */
package com.day.cq.dam.api.s7dam.set;

import java.util.Iterator;

import org.apache.sling.api.resource.Resource;
import org.osgi.annotation.versioning.ProviderType;

import com.day.cq.dam.api.Asset;

/**
 * Represents a Scene7 Media set.
 * @deprecated Not for public use - this API will be replaced in a future release
 *
 */
@Deprecated
@ProviderType
public interface MediaSet extends Resource {

    /**
     * Returns an iterator over assets in the Media Set
     * 
     * @return iterator over assets {@link Asset} in collection.
     */
    Iterator<Asset> getMembers();

    /**
     * Checks if the given asset is valid member type of Media Set
     * 
     * @param asset The asset whose type needs to be checked for membership
     * @return True if asset type is valid for set, false otherwise.
     */
    boolean isValidMemberType(Asset asset);

    /**
     * Returns true if <code>asset</code> is part of Image Set
     * 
     * @param asset asset instance to be checked
     * @return <code>true</code> if <code>asset</code> is part of the Image Set.
     *         <code>false</code> otherwise
     */
    boolean contains(Asset asset);

    /**
     * Add an <code>asset</code> to the image set and returns true if
     * successful.
     * 
     * @param asset asset instance to be added
     * @return true if addition of resource to collection was successful or
     *         false if collection already contained the resource.
     */
    boolean add(Asset asset);

    /**
     * Add an <code>asset</code> to the image set and returns true if
     * successful.
     *
     * @param asset {@link Asset} instance to be added
     * @param swatch {@link Asset} as a swatch for this asset
     * @return true if addition of resource to collection was successful or
     *         false if collection already contained the resource.
     */
    boolean add(Asset asset, Asset swatch);

    /**
     * Removes an {@link Asset} from image set &amp; returns true if successful
     * 
     * @param asset {@link Asset} to be removed
     * @return <code>true</code> if <code>asset</code> was successfully removed
     *         from the collection. <code>false</code> otherwise
     */
    boolean remove(Asset asset);

    /**
     * Change the order of assets in image set.
     * 
     * @param srcAsset {@link Asset} that needs to be moved in the order
     * @param destAsset {@link Asset} before which the <code>srcAssetPath</code>
     *            will be placed. <code>destAsset</code> is null, then srcAsset
     *            will be placed at the end of the list.
     * @throws IllegalArgumentException if asset is null or if
     *         <code>asset</code> or <code>beforeAsset</code> does not exist in set
     */
    void orderBefore(Asset srcAsset, Asset destAsset);

    /**
     * Returns the type of the set.
     * 
     * @return type of the set i.e. ImageSet, SwatchSet
     */
    String getType();

}
