/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.api.s7dam.set;

import org.osgi.annotation.versioning.ProviderType;

import com.day.cq.dam.api.Asset;

/**
 * Represents a Scene7 Swatch Set.
 * @deprecated  use {@link MediaSet}
 * 
 */
@Deprecated
@ProviderType
public interface SwatchSet extends ImageSet {
    /**
     * Add an <code>asset</code> and <code>swatch</code> to the swatch set and
     * returns true if successful.
     * 
     * @param asset {@link Asset} instance to be added
     * @param swatch {@link Asset} instance to be added as <code>swatch</code>.
     * @return <code>true</code> if operation is successful.
     *        or <code>false</code> if <code>asset</code> is already contained in the resource.
     * 
     */
    boolean add(Asset asset, Asset swatch);
    
    /**
     * Returns the swatch for an {@link Asset} which is the part of the Swatch Set.
     * @param asset {@link Asset} for which a swatch is to be found
     * @return swatch for an {@link Asset} in swatch set.
     */
    Asset getSwatch(Asset asset);
    
    /**
     * Sets the swatch for an {@link Asset} which is the part of the Swatch Set.
     * 
     * @param asset {@link Asset} for which a swatch is to be set
     * @param swatch {@link Asset} which is to be used as swatch
     */
    void setSwatch(Asset asset, Asset swatch);
}
