/* ************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2021 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any.  The
 * intellectual and technical concepts contained herein are
 * proprietary to Adobe and its suppliers and are protected
 * by all applicable intellectual property laws, including
 * trade secret and copyright laws.  Dissemination of this
 * information or reproduction of this material is strictly
 * forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.dam.api.smartcrop;

import java.util.Collection;
import java.util.List;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;

import org.osgi.annotation.versioning.ProviderType;
@ProviderType
public interface AssetSmartCropStore {
    
    /**
     * Lists all {@link SmartCrop}s for an asset
     *
     * @param asset asset
     * 
     * @return all available {@link SmartCrop}s
     */
    Collection<SmartCrop> getSmartCrops(Asset asset);

    /**
     * Removes the smart crops renditions for an asset
     * @param asset Asset for which the smart crops need to be removed
     * @param crops Smart crop names which are to be removed.
     */
    void removeSmartCrops(Asset asset, List<String> crops) ;

    /**
     * Adds or updates crops as renditions. This method will replace any
     * existing crops of the same name .
     *
     * @param asset Asset to which crops are to be stored.
     * 
     * @param crops Smart Crops to assign to the asset.
     * 
     * @return collection of {@link com.day.cq.dam.api.Rendition}s corresponding to input crops
     */
    Collection <Rendition> addOrUpdateSmartCrops(Collection <SmartCrop> crops, Asset asset);
    
    /**
     * Returns true if the asset has {@link SmartCrop}s stored in jcr as
     * renditions
     *
     * @param asset asset
     * @return true or false depending upon if asset has smartcrop renditions
     */
    boolean hasLocalCropDefns(Asset asset);

    /**
     * Sets a property 'manualCrop' with the "value" to the the asset's smart crop rendition
     * @param asset Asset
     * @param cropName Smart Crop name
     * @param value true or false to the 'manualCrop' property
     */
    void setManualCropFlag(Asset asset, String cropName, boolean value);

    /**
     * Returns the value of 'manualCrop' property for the Asset's smart crop rendition.
     * @param asset Asset
     * @param cropName Smart Crop name
     * @return true or false depending upon if asset's smartcrop renditions is manually edited.
     */
    boolean isManualCropped(Asset asset, String cropName);

}
