/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.api.thumbnail;

/**
 * This interface specifies the accessors for a thumbnail configuration.
 * @since CQ 5.4.0
 */
public interface ThumbnailConfig {

    /**
     * Name of the configuration property for the thumbnail's width.
     */
    static final String PN_WIDTH = "width";

    /**
     * Name of the configuration property for the thumbnail's height.
     */
    static final String PN_HEIGHT = "height";

    /**
     * Name of the configuration property for whether the thumbnail shall be rendered centered or not.
     */
    static final String PN_DOCENTER = "doCenter";

    /**
     * Retrieves the width in pixels for a thumbnail.
     *
     * @return The width of the thumbnail.
     */
    int getWidth();

    /**
     * Retrieves the height in pixels for a thumbnail.
     *
     * @return The height of the thumbnail.
     */
    int getHeight();

    /**
     * Returns whether this thumbnail is rendered centered.
     *
     * @return <code>true</code> if the thumbnail is rendered centered.
     */
    boolean doCenter();
}
