/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.commons.preset;

/**
 * Scene7 Preset Type enum
 *
 */
public enum PresetType {
    VIEWER("viewer","presets/viewer"),
    IMAGE("image","imageserver/macros"),
    VIDEO("video","video/dynamicmedia");

    private String defaultPresetPath = "";
    private String name = "";

    PresetType(String name, String defaultPresetPath) {
        this.name = name;
        this.defaultPresetPath = defaultPresetPath;
    }

    public static PresetType getPresetTypeByName(String name){
        PresetType presetType = null;
        for(PresetType pt : values()){
            if (pt.name.equalsIgnoreCase(name)) {
                presetType = pt;
                break;
            }
        }
        return presetType;
    }

    public String getDefaultPresetPath(){
        return this.defaultPresetPath;
    }

    public String getName(){
        return this.name;
    }

};
