/*************************************************************************
*
* ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2011 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe Systems Incorporated.
**************************************************************************/
package com.day.cq.dam.commons.proxy;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import com.day.cq.wcm.webservicesupport.ConfigurationManagerFactory;

@Component(metatype=false)
@Service
@Properties({
	@Property(name="process.label", value="DAM Cloud Config Helper Service")
})
public class ProxyConfigImpl implements ProxyConfig {

    private static final Logger log = LoggerFactory.getLogger(ProxyConfigImpl.class);

    @Reference(policy = ReferencePolicy.STATIC)
    private ConfigurationManagerFactory configurationManagerFactory;

    public Configuration getConfiguration(ResourceResolver resourceResolver) {
        ConfigurationManager configManager = configurationManagerFactory.getConfigurationManager(resourceResolver);
        return configManager.getConfiguration(PROXY_CLOUD_CONFIG);
    }

    public Configuration getConfiguration(ResourceResolver resourceResolver, String worker) {
        ConfigurationManager configManager = configurationManagerFactory.getConfigurationManager(resourceResolver);
        return configManager.getConfiguration(PROXY_CLOUD_CONFIG + "/" + worker);
    }

}
