package com.day.cq.dam.commons.util;

import com.day.cq.dam.api.s7dam.constants.S7damConstants;

// Any constants that need to be exposed outside the bundle must be elevated to super interface
//
public interface S73DConstants extends S7damConstants {
	
	public static final String[] MODEL_MIME_TYPES = { 
    	"model/iges", // IGS files, IGES files; Defined in RFC 2077
    	"model/mesh", // MSH files, MESH files; Defined in RFC 2077, SILO files
    	"model/vrml", // WRL files, VRML files; Defined in RFC 2077
    	"model/x3d+binary", // X3D ISO standard for representing 3D computer graphics, X3DB binary files - never Internet Assigned Numbers Authority approved
    	"model/x3d+fastinfoset", // X3D ISO standard for representing 3D computer graphics, X3DB binary files (application in process, this replaces any use of model/x3d+binary)
    	"model/x3d-vrml", // X3D ISO standard for representing 3D computer graphics, X3DV VRML files (application in process, previous uses may have been model/x3d+vrml)
    	"model/x3d+xml", // X3D ISO standard for representing 3D computer graphics, X3D XML files
    	"model/example", // example in documentation, Defined in RFC 4735
    };
    
	public static final String[] SUPPORTED_3D_FORMATS = { 
    	"v3d",
    	"fbx",
    	"obj",
    	"ma",
    	"3ds"
    };
	
    public static final String SETTINGS_NODE ="apps/cq-scene7-v3D/config/settings";

    /**
     * V3D Progress Node.
     */
	public static final String S73D_PROGRESS = "progress";
	   
	   /**
	    * V3D Progress Node.
	   */
	public static final String S73D_NO_OP = "No Operation";

    /**
     * Type that defines a native v3D model.
     */
     public static final String S73D_V3D = "V3D_Model";
   
     // 3d model types
     public static final String S73D_OBJECT = "3D Object";
     public static final String S73D_SCENE = "3D Scene";
     public static final String S73D_STAGE = "3D Stage";

    /**
     * Type that defines an AutoDesk fbx model.
     */
    public static final String S73D_FBX = "FBX_Model";
    
    /**
     * Type that defines a Wavefront obj model.
     */
    public static final String S73D_OBJ = "OBJ_Model";

 	
    /**
     * S73D property - No of Vertices
     */
    public static final String PN_S73D_NO_VERTICES = "dam:s73Ddam_No_Vertices";

    /**
     * S73D property - No of Vertices
     */
    public static final String PN_S73D_NO_FACES = "dam:s73Ddam_No_Faces";
    
    /**
     * S73D property - No of Vertices
     */
    public static final String PN_S73D_NO_NORMALS = "dam:s73Ddam_No_Normals";
    
    /**
     * S73D property - No of Vertices
     */
    public static final String PN_S73D_NO_TEXTURE_COORDS = "dam:s73Ddam_No_TextureCoords";
    
    /**
     * S73D property - No of Vertices
     */
    public static final String PN_S73D_NO_WEDGES = "dam:s73Ddam_No_Wedges";
    
}
