/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.indd;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMException;
import org.apache.sling.api.resource.ValueMap;

import java.util.List;

/**
 * The PageBuilder interface.
 * <p>
 * This interface can be used to create {@link Page}s and {@link PageComponent}s. A page is basically designed as a list
 * of optionally nested {@link PageComponent}s. Use the {@link PageBuilderFactory} service to get a {@link PageBuilder} instance.
 * <p>
 * This interface must not be implemented by clients.
 *
 * @since 5.5
 */
public interface PageBuilder {

    /**
     * Convenience method to create a {@link PageComponent} for a resource type.
     *
     * @param resourceType The {@link PageComponent}s resource type
     * @return The {@link PageComponent}
     */
    public PageComponent createComponent(String resourceType);

    /**
     * Convenience method to create a {@link PageComponent} for a resource type and the given properties.
     *
     * @param resourceType The {@link PageComponent}s resource type
     * @param properties   The {@link PageComponent}s properties
     * @return The {@link PageComponent}
     */

    public PageComponent createComponent(String resourceType, ValueMap properties);


    /**
     * Factory method to create a new {@link PageComponent}.
     *
     * @param resourceType The {@link PageComponent}s resource type
     * @param properties   The {@link PageComponent}s properties
     * @param nameHint     The name hint for the {@link PageComponent}
     * @return The {@link PageComponent}
     */
    public PageComponent createComponent(String resourceType, ValueMap properties, String nameHint);

    /**
     * Create a new {@link Page}.
     *
     * @param pageRoot     The page root
     * @param pageName     The page name
     * @param pageTitle    The page title
     * @param templatePath The path to the template to use
     * @param designPath   The path to the design to use
     * @param components   List of optionally nested {@link PageComponent}s that make up the page.
     * @return The new page.
     * @throws WCMException exception caused while creating the page.
     */
    public Page createPage(String pageRoot, String pageName, String pageTitle, String templatePath, String designPath, List<PageComponent> components) throws WCMException;

    /**
     * Recreate a {@link Page}.
     *
     * @param pageRoot     The page root
     * @param pageName     The page name
     * @param pageTitle    The page title
     * @param templatePath The path to the template to use
     * @param designPath   The path to the design to use
     * @param components   List of optionally nested {@link PageComponent}s that make up the page.
     * @return The recreated page.
     * @throws WCMException exception caused while creating the page.
     */
    public Page recreatePage(String pageRoot, String pageName, String pageTitle, String templatePath, String designPath, List<PageComponent> components) throws WCMException;
}
