/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.dam.performance.api;

import org.apache.sling.api.resource.PersistenceException;

import aQute.bnd.annotation.ProviderType;

import com.day.cq.dam.api.Asset;

/**
 * The <code>AssetPerformanceTracker</code> interface provides the methods for
 * reading and setting the asset performance record.
 */
@ProviderType
public interface AssetPerformanceTracker {

    /**
     * Gets the asset impression count for the <code>asset</code>.
     * @param asset the assets whose impression count is to be found
     * @return the asset impression count for the asset
     */
    long getAssetImpressionCount(Asset asset);

    /**
     * Gets the asset click count for the <code>asset</code>.
     * @param asset the assets whose click count is to be found
     * @return the asset click count for the asset
     */
    long getAssetClickCount(Asset asset);

    /**
     * Sets the asset click count for the <code>asset</code>.
     * @param asset the assets whose click count is to be set
     * @param count the click count to be set
     * @throws PersistenceException thrown in case of error while setting the asset click count
     */
    void setAssetClick(Asset asset, Long count) throws PersistenceException;

    /**
     * Sets the asset impression count for the <code>asset</code>.
     * @param asset the assets whose impression count is to be set
     * @param count the impression count to be set
     * @throws PersistenceException thrown in case of error while setting the asset impression count
     */
    void setAssetImpression(Asset asset, Long count)
            throws PersistenceException;

    /**
     * Sets the asset click and impression count for the <code>asset</code>.
     * @param asset the assets whose click and impression count is to be set
     * @param clickCount the click count to be set
     * @param impressionCount the impression count to be set
     * @throws PersistenceException thrown in case of error while setting the asset click or impression count
     */
    void setAssetPerformance(Asset asset, Long impressionCount, Long clickCount)
            throws PersistenceException;
}
