/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The <code>Scene7Service</code> provides methods for interacting with the official Scene7 API.
 */
@ProviderType
public interface Scene7UploadService {

    static final String SCR_PROP_NAME_ACTIVE_JOB_TIMEOUT_NAME = "cq.dam.scene7.uploadservice.activejobtimeout.label";
    static final int SCR_PROP_NAME_ACTIVE_JOB_TIMEOUT_DEFAULT_VALUE = 35 * 60;
    static final String SCR_PROP_NAME_CONN_MAX_PER_ROUTE_NAME = "cq.dam.scene7.uploadservice.connectionmaxperroute.label";
    static final int SCR_PROP_NAME_CONN_MAX_PER_ROUTE_DEFAULT_VALUE = 10;

    /**
     * Uploads a file at a given repository path to the Scene7 server.
     * 
     * @param path
     *            Path to the file in the repository
     * @param cloudServiceConfigPath
     * @param resolver
     *            Sling ResourceResolver
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     */
    String uploadFile(String path, String cloudServiceConfigPath, ResourceResolver resolver);

    /**
     * Uploads a folder at a given repository path to the Scene7 server.
     * 
     * @param path
     *            to the folder
     * @param cloudServiceConfigPath
     * @param resolver
     * @return String Scene7 job handle
     */
    String uploadFolder(String path, String cloudServiceConfigPath,
            ResourceResolver resolver);

    /**
     * Synchronises a file at a given repository path back into the Scene7
     * server.
     * 
     * @param path
     *            Path to the file in the repository
     * @param assetResolver
     *            Sling ResourceResolver to access AEM asset
     * @param configResolver
     *            Sling ResourceResolver to access AEM-Scene7 configuration
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     */
    String synchronizeFile(String path, ResourceResolver assetResolver,
            ResourceResolver configResolver);

    /**
     * Moves an S7 managed file ( a file that has an associated S7 assetHandle)
     * at a given repository path back into the Scene7 server.
     * 
     * @param path
     *            Path to the file in the repository
     * @param assetResolver
     *            Sling ResourceResolver to access AEM asset
     * @param configResolver
     *            Sling ResourceResolver to access AEM-Scene7 configuration
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     * 
     * @deprecated use
     *             {@link com.day.cq.dam.scene7.api.Scene7Service#moveAsset(S7Config,Resource,String)}
     *             instead
     */
    @Deprecated
    String moveFile(String path, ResourceResolver assetResolver,
            ResourceResolver configResolver);

    /**
     * Moves a folder (including sub folders/assets) back to the Scene7 server.
     * 
     * @param dstpath
     *            destination path to the file in the repository
     * @param srcpath
     *            Original path of the folder in the repository
     * @param assetResolver
     *            Sling ResourceResolver to access AEM asset
     * @param configResolver
     *            Sling ResourceResolver to access AEM-Scene7 configuration
     * @return String 'success' if upload finished successfully or a
     *         representation of the job handle if upload failed.
     * 
     * @deprecated use
     *             {@link com.day.cq.dam.scene7.api.Scene7Service#moveFolder(S7Config,String,String)}
     *             instead
     */
    @Deprecated
    String moveFolder(String dstpath, String srcpath,
            ResourceResolver assetResolver, ResourceResolver configResolver);

    /**
     * Retrieve Scene7 upload job timeout parameter
     *
     * @return long Scene7 active job timeout
     */
    long getActiveJobTimeOut();

    /**
     * Retrieve Scene7 upload job maximum number of connections
     * 
     * @return int Scene7 connections
     */
    int getConnectionMaxPerRoute();
}
