/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2020 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.constants;

/**
 * This ENUM stores the Scene7 publish modes.
 */

public enum Scene7PublishMode {

        IMMEDIATE("off"), MANUAL("on"), SELECTIVE("selective");

        private String value;

        private Scene7PublishMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Scene7PublishMode fromString(String mode) {
            if (IMMEDIATE.value.equalsIgnoreCase(mode)
                || IMMEDIATE.name().equalsIgnoreCase(mode)) {
                return IMMEDIATE;
            } else if (MANUAL.value.equalsIgnoreCase(mode)
                || MANUAL.name().equalsIgnoreCase(mode)) {
                return MANUAL;
            } else if (SELECTIVE.value.equalsIgnoreCase(mode)) {
                return SELECTIVE;
            }
            return null;
        }
}
