/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.dam.scene7.api.model;

import java.util.Date;
import java.util.List;

/**
 * Abstraction of a Scene7 folder structure
 */
public interface Scene7Folder {
    
    /**
     * Returns this folder's S7 handle
     * 
     * @return a <code>String</code> containing the Scene7 folder handle
     */
    public abstract String getFolderHandle();
    
    /**
     * Returns this folder's S7 path
     * 
     * @return a <code>String</code> containing the Scene7 folder path
     */
    public abstract String getPath();
    
    /**
     * Returns the last modified date of this S7 folder
     * 
     * @return a <code>Date</code> object containing the last modified date of this Scene7 folder
     */
    public abstract Date getLastModified();
    
    /**
     * Returns the list of sub folders of this S7 folder
     * 
     * @return a <code>List</code> containing the Scene7 sub-folders for this folder
     */
    public abstract List<Scene7Folder> getSubFolders();
    
    /**
     * Returns if it has sub folders for this S7 folder
     * 
     * @return a <code>Boolean</code> indicate if it contains sub-folders for this folder
     */
    public abstract Boolean hasSubFolders();
    
    /**
     * Includes the subFolder parameter in the list of sub folders of this S7 folder
     * 
     * @param subFolder
     *            a <code>Scene7Folder</code> object
     */
    public abstract void addSubFolder(Scene7Folder subFolder);
}
