/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.dam.video;

/**
 * Property names for video profiles.
 */
public interface VideoConstants {

    //properties for CQ type of video profiles only
    static final String PN_OUTPUT_EXTENSION        = "extension";
    static final String PN_OUTPUT_MIMETYPE         = "mimeType";
    static final String PN_CUSTOM_ARGS             = "customArgs";
    static final String PN_CUSTOM_ARGS_ONLY        = "customArgsOnly";
    static final String PN_TWO_PASS                = "twoPass";
    static final String PN_VIDEO_WIDTH             = "width";
    static final String PN_VIDEO_HEIGHT            = "height";
    static final String PN_VIDEO_FIT_INSIDE        = "fitInside";
    static final String PN_VIDEO_LETTERBOX         = "letterBox";
    static final String PN_VIDEO_CODEC             = "videoCodec";
    static final String PN_VIDEO_FRAME_RATE        = "videoFrameRate";
    static final String PN_VIDEO_BITRATE           = "videoBitrate";
    static final String PN_VIDEO_BITRATE_TOLERANCE = "videoBitrateTolerance";
    static final String PN_AUDIO_CODEC             = "audioCodec";
    static final String PN_AUDIO_CHANNELS          = "audioChannels";
    static final String PN_AUDIO_SAMPLING_RATE     = "audioSamplingRate";
    static final String PN_AUDIO_BITRATE           = "audioBitrate";
    static final String PN_RENDITION_SELECTOR      = "renditionSelector";

    //properties for both, S7 and CQ type of video profiles
    static final String PN_HTML_VIDEO_TYPE         = "htmlType";

    //properties for the S7 type of video profiles only
    /** path to the cached preset in CQ **/
    static final String S7PN_PRESET_PATH           = "preset";
    static final String S7PN_ACTIVE                = "active";
    static final String S7PN_ASPECT_RATIO          = "aspectRatio";
    static final String S7PN_DESCRIPTION           = "description";
    static final String S7PN_EXTENSION             = "extension";
    static final String S7PN_PRESET_HANDLE         = "handle";
    static final String S7PN_HEIGHT                = "height";
    static final String S7PN_NAME                  = "name";
    static final String S7PN_PLAYBACK_ON           = "playbackOn";
    static final String S7PN_TARGET_BIT_RATE       = "targetBitRate";
    static final String S7PN_WIDTH                 = "width";

    static final String RENDITION_PREFIX           = "cq5dam.video.";
}
