/*
 * Copyright 1997-2004 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.graphics.chart;

/**
 * @author tripod
 */
public class Data {
    String[] labels; // usually the first line
    double[][] samples;
    int numrows; // of samples
    int numcols; // of samples
    DataRow[] datarows;
    int[][] xcoords;
    int[][] ycoords;

    public Data(int numrows, int numcols) {
	this.numrows = numrows;
	this.numcols = numcols;
	this.datarows = new DataRow[numrows];
	this.xcoords = new int[numrows][numcols];
	this.ycoords = new int[numrows][numcols];
    }

    public void setSamples(double[][] samples) {
	if (samples == null || samples.length == 0 || samples[0] == null ||
	    samples[0].length == 0) {
	    throw new IllegalArgumentException("Samples must not be empty");
	}

	this.samples = samples;

	// prepare the data rows...
        for (int i=0; i<numrows && i<samples.length; i++) {
	    datarows[i] = new DataRow(i, samples[i]);
	}
    }

    public void setLabels(String[] labels) {
	if (labels == null) labels = new String[0];
	this.labels = labels;
    }

    public void setLegends(String[] legends) {
	if (legends == null) legends = new String[0];
	for (int i=0; i<numrows && i<legends.length; i++) {
	    datarows[i].label = legends[i];
	}
    }

    public int getNumrows() {
	return numrows;
    }

    public int getNumcols() {
	return numcols;
    }

    public DataRow getDataRow(int i) {
	if (i >= 0 && i < datarows.length) {
	    return datarows[i];
	} else {
	    return null;
	}
    }

    public int getXCoord(int row, int col) {
	return xcoords[row][col];
    }

    public int getYCoord(int row, int col) {
	return ycoords[row][col];
    }
}
