/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mailer;

import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;

/**
 * The <code>MailService</code> can be used to send emails.
 * The mail service is already configured with a mail host,
 * mail port and from address.
 * These values can be overwritten in the supplied email object.
 * This is a convenience to access an OSGI Service for a
 * {@link com.day.cq.mailer.MessageGateway MessageGateway}
 * of type {@link org.apache.commons.mail.Email Email} 
 * @see MessageGateway
 */
public interface MailService extends MessageGateway<Email> {

    /**
     * Send an email.
     * The mail service is already configured with a mail host,
     * mail port and from address.
     * These values can be overwritten in the supplied email object.
     * @param email The email to sent.
     * @throws org.apache.commons.mail.EmailException in case sending fails
     * @deprecated since 5.4 use {@link #send(Object)} instead}
     */
    void sendEmail(Email email) throws EmailException;
}
