/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mailer;

import java.util.Date;

import javax.jcr.RepositoryException;

/**
 * Accesses the status of a given Mailing.
 *
 * @see MailingService#send(MessageTemplate, AuthorizableMailingList, org.apache.sling.api.resource.ResourceResolver)
 * @since 5.4
 */
public interface MailingStatus {

    /**
     * @return the ID of the Mailing this is the status for
     */
    String getMailingID();

    /**
     * @return <code>true</code> in case there has been no attempt to send
     */
    boolean isNew();

    /**
     * @return <code>true</code> in case the sending has been successful 
     */
    boolean isSent();

    /**
     * Indicates if there has been an error processing the send of the Mailing.
     * Mailing may be {@link #isSent() sent} and have errors, that did not
     * prevent the sending of all messages. 
     * @return <code>true</code> in case the sending has ben done.
     */
    boolean hasError();

    /**
     * @return the amount of recipients that have been successfully delivered.
     */
    long numSent();

    /**
     * @return TimeStamp last change on state took place
     */
    Date getLastModified();

   /**
     * @return the Code of the Mailings status
     * @throws RepositoryException in case of error accessing the Persistance
     * @see MailingStatusCode
     */
    MailingStatusCode getStatusCode() throws RepositoryException;
    //todo: add recipientStatus here somthing like a map<authid, messageStatusCode>
}
