/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mailer;

/**
 * OSGI Service to access the available Gateways for a message of a given type.
 * An example of such a message would be an {@link org.apache.commons.mail.Email Email}
 * 
 * @see MessageGateway
 * @since 5.4
 */
public interface MessageGatewayService {

    /**
     * Returns the gateway.
     * @param type of the message a gateway is requested
     * @param <Type> The message type.
     * @return the MessageGateway or <code>null</code> if non registered for this type
     */
    <Type> MessageGateway<Type> getGateway(Class<? extends Type> type);
}