/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.day.cq.mcm.api;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

import com.day.cq.wcm.api.Page;

/**
 * A location to present an {@link Experience} at. For example a group (mailing
 * list) to which a newsletter can be sent.
 *
 */
public interface Touchpoint {

	MCMPlugin getPlugin();

	/**
	 * Provide an expression that can be added in the condition part of an
	 * XPath query to match experiences for this {@link Touchpoint}. Experiences are 
	 * filtered by resource type only otherwise.
	 * @return
	 */
	String getXPathAdditionToMatchTouchpointExperience();
	
	/**
     * If the account has been connected with a remote publishing service. 
     * @return
     */
    public boolean isConnected();
    
    /**
     * The identification - for example screen name for Twitter.
     * @return
     */
    public String getAccountName();
    
    /**
     * The name of the account in the JCR.
     * @return
     */
    public String getTitle();
    
    /**
     * Return the <code>jcr:contentNode</code> in usable form.
     * @return
     */
    public ValueMap getProperties();
    
    /**
     * Name of the service, for example 'Twitter'.
     * @return
     */
    public String getServiceName();
    
    /**
     * If published, returns the link to the account's page on the service.
     * For example:
     * <pre>
     * http://twitter.com/[twitterName]
     * </pre>. 
     * @return
     */
    public String getUrlOnService();
    
    /**
     * The resource of the account (not the content resource).
     */
	public Resource getResource();
	
	/**
     * The resource of the account - as page.
     * @return
     */
    public Page getPage();

}
