/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.mcm.campaign;

/**
 * Defines constants used for communicating with an Adobe Campaign instance.
 */
public final class RpcDefs {

    private RpcDefs() {
        // static helper class
    }

    /**
     * Basic API path
     */
    public static final String API_PATH = "/jssp/nms/";

    /**
     * Format of the session token - sent as parameter {@link #PRM_SESSIONTOKEN}
     */
    public static final String TOKEN = "#user#/#password#";

    /**
     * RPC parameter: session token
     */
    public static final String PRM_SESSIONTOKEN = "__sessiontoken";

    /**
     * RPC parameter: delivery mapping (AC 6.1)
     */
    public static final String PRM_MAPPING = "mapping";

    /**
     * RPC parameter: resource (= delivery mapping on AC .next)
     */
    public static final String PRM_RESOURCE = "resource";

    /**
     * RPC parameter: template
     */
    public static final String PRM_TEMPLATE = "template";

    /**
     * RPC parameter: encrypted primary key
     */
    public static final String PRM_ENCRYPTED_PK = "encryptedPK";

    /**
     * RPC parameter: search term
     */
    public static final String RPC_PRM_QUERY = "searchTerm";

    /**
     * RPC parameter: first entry to retrieve
     */
    public static final String RPC_PRM_START = "startLine";

    /**
     * RPC parameter: max entries to retrieve
     */
    public static final String RPC_PRM_LIMIT = "lineCount";

}
