/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.day.cq.mcm.campaign;

import com.day.cq.i18n.I18n;
import org.apache.sling.api.resource.Resource;

/**
 * Service for retrieving the current status of a newsletter from a Adobe Campaign instance.
 */
public interface StatusService {

    /**
     * Retrieves the status of the newsletter represented by the specified @link Resource}.
     *
     * @param resource The resource representing the newsletter
     * @param i18n The internationalization object
     * @return The status of the newsletter
     * @throws ACConnectorException if the status could not be retrieved
     */
    NewsletterStatus retrieveStatus(Resource resource, I18n i18n)
            throws ACConnectorException;

}
