/*
 * ***********************************************************************
 *
 *  ADOBE CONFIDENTIAL
 *  ___________________
 *
 *   Copyright 2012 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 * ************************************************************************
 */

package com.day.cq.mcm.emailprovider.types;

import java.util.Map;


/**
 * Defines interface for all the Personalization mappings for an email provider.
 */
public interface PersonalizationInfo {
    public static final String PERSONALIZATION_KEY = "personalization";

    /**
     * This function adds a personalization mapping
     * @param attributeName name of the attribute
     * @param replacementText replacement string to be used
     */
    public void addMapping(String attributeName, String replacementText);

    /**
     * This function removes a personalization mapping
     * @param attributeName name of the attribute that needs to be removed.
     */
    public void removeMapping(String attributeName);

    /**
     * This function returns the mapping corresponding to an attribute
     * @param attributeName attribute name
     * @return attribute replacement text for the attribute
     */
    public String getMapping(String attributeName);

    /**
     * This function returns all attribute name and replacemenet text mappings.
     * @return A map containing all the mappings.
     */
    public Map<String, String> getAllMappings();
    /**
     * This function returns the prefix to be used with replacement text.
     * @return The prefix
     */
    public String getPrefixPattern();

    /**
     * This function sets the prefix to be used for the replacement text
     * @param prefixPattern The prefix.
     */
    public void setPrefixPattern(String prefixPattern);

    /**
     * This function returns the suffix to be used with replacement text.
     * @return The prefix
     */
    public String getSuffixPattern();

    /**
     * This function sets the suffix to be used with replacement text.
     * @param suffixPattern
     */
    public void setSuffixPattern(String suffixPattern);
    
    /**
     * This function tells whether prefix has to be added to replacement text or not.
     * @return true if prefix has to be added and false otherwise.
     */
    public boolean usePrefix();
    /**
     * This function tells whether suffix has to be added to replacement text or not.
     * @return true if suffix has to be added and false otherwise.
     */
    public boolean useSuffix();
}
